//  Created by João Ramalho and Paulo André on 23/05/2019.
//  Copyright © 2019 João Ramalho. All rights reserved.
//

import UIKit
import AVFoundation

extension UIImage {
    
    func getPixelColor(atLocation location: CGPoint, withFrameSize size: CGSize)-> UIColor {
        
        let x: CGFloat = (self.size.width) * location.x / size.width
        let y: CGFloat = (self.size.height) * location.y / size.height
        let pixelPoint: CGPoint = CGPoint(x: x, y: y)
        let pixelData = self.cgImage!.dataProvider!.data
        let data: UnsafePointer<UInt8> = CFDataGetBytePtr(pixelData)
        let pixelIndex: Int = ((Int(self.size.width) * Int(pixelPoint.y)) + Int(pixelPoint.x)) * 4
        let r = CGFloat(data[pixelIndex]) / CGFloat(255.0)
        let g = CGFloat(data[pixelIndex+1]) / CGFloat(255.0)
        let b = CGFloat(data[pixelIndex+2]) / CGFloat(255.0)
        let a = CGFloat(data[pixelIndex+3]) / CGFloat(255.0)
 
        return UIColor(red: r, green: g, blue: b, alpha: a)
    }
}


class ViewController: UIViewController, UINavigationControllerDelegate, UIImagePickerControllerDelegate, UIGestureRecognizerDelegate {
    
    var imagePicker: UIImagePickerController!
    var tapinha : CGPoint!

    @IBOutlet weak var imageView: UIImageView!
    @IBOutlet var tapGesture: UITapGestureRecognizer!
    @IBOutlet weak var photoTake: UIButton!
    @IBOutlet weak var splitButton: UIButton!
    @IBOutlet weak var QRscan: UIButton!
    @IBOutlet weak var chooseBuuton: UIButton!
    @IBOutlet weak var messageQR: UILabel!
    @IBOutlet weak var ratio: UILabel!
    
    
    // storyboards functions
    
    @IBAction func TakePhoto(_ sender: Any) {
        
        imagePicker = UIImagePickerController()
        imagePicker.delegate = self
        imagePicker.sourceType = .camera
        imagePicker.cameraFlashMode = UIImagePickerController.CameraFlashMode.off

        present(imagePicker, animated: true, completion: nil)
    }
    
    @IBAction func taptap(_ tapRecognize: UITapGestureRecognizer) {
        
        if tapRecognize.state == .ended {
            
            let locationTap = tapRecognize.location(in: imageView)
    
            tapinha = locationTap
            
            let xx: CGFloat = imageView.frame.size.width
            let yy: CGFloat = imageView.frame.size.height
            var rad :CGFloat
            
            if xx<yy{
                rad = xx*0.02
                print("xx = \(rad)")
            }else{
                rad = yy*0.02
                print("yy = \(rad)")
            }
            
            let circlePath = UIBezierPath(arcCenter: tapinha, radius: rad, startAngle: CGFloat(0), endAngle:CGFloat(Double.pi * 2), clockwise: true)
            let shapeLayer = CAShapeLayer()
            
            shapeLayer.path = circlePath.cgPath
            shapeLayer.fillColor = UIColor.clear.cgColor
            shapeLayer.strokeColor = UIColor.white.cgColor
            shapeLayer.lineWidth = 1.0
            
            imageView.layer.sublayers = nil;
            imageView.layer.addSublayer(shapeLayer)
        }
    }
 
    @IBAction func splitColour(_ sender: UIButton) {
        
        if (tapinha) != nil {
            
            let coord = getAreaColor(atLocation: tapinha, withFrameSize: imageView.frame.size)
        
            var red: CGFloat = 0
            var green: CGFloat = 0
            var blue: CGFloat = 0
            var alpha: CGFloat = 0
            var r : CGFloat
            var rt : CGFloat
            var t : CGFloat
            var dN : CGFloat
            let cf = CGFloat(0) //correcction factor
 
            coord.getRed(&red, green: &green, blue: &blue, alpha: &alpha)
        
            r = (round((green/red)*1000)/1000) - cf
            rt = ((r*(1+0.106))/2.4) + (0.106/2.4)
            dN = (1/rt) - 1
            t = 1/((1/281) - ((1/3056)*(log(dN)-1.66878)))
        
            print(red, green, blue, alpha)
            print(t)
            print(r)
            print(dN)
            ratio.text = "T = \(round(t) - 273) ºC"
            
        }else{
            
            if (imagePicker) != nil{
                messageQR.text = "Please select a point in the image"
            }else{
                messageQR.text = "Take a photo or choose an image"
            }
        }
    }
    
    @IBAction func scanQR(_ sender: Any) {
        
        if (imagePicker) != nil {

            if let qrcodeImg = imageView.image {
                
                var qrCodeLink=""
            
                let detector:CIDetector=CIDetector(ofType: CIDetectorTypeQRCode, context: nil, options: [CIDetectorAccuracy:CIDetectorAccuracyHigh])!
                let ciImage:CIImage=CIImage(image:qrcodeImg)!
                let features=detector.features(in: ciImage)
                
                for feature in features as! [CIQRCodeFeature] {
                    qrCodeLink += feature.messageString!
                }
                
                if qrCodeLink=="" {
                        
                    messageQR.text = "No QR code found."
                    splitButton.isEnabled = false
                        
                }else{
                        
                    messageQR.text = "\(qrCodeLink)"
                    splitButton.isEnabled = true
                }
            }else{
            
            messageQR.text = "something went wrong"
            }
            self.dismiss(animated: true, completion: nil)
        }
    }
 
    @IBAction func btnClicked(_ sender: Any) {
        
        imagePicker = UIImagePickerController()
        imagePicker.delegate = self
        imagePicker.sourceType = .photoLibrary
        imagePicker.allowsEditing = false
        
        present(imagePicker, animated: true, completion: nil)
        
        messageQR.text = "QR code message"
        ratio.text = "Temperature measured"
    }
    
    // user Functions
    
    
    func imagePickerController(picker: UIImagePickerController!, didFinishPickingImage image: UIImage!){
        
        imageView.image = image
        self.dismiss(animated: true, completion: { () -> Void in})
        
    }
    
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [UIImagePickerController.InfoKey : Any]) {
        
        imageView.contentMode = .scaleAspectFit
        imageView.image = info[.originalImage] as? UIImage
        self.dismiss(animated: true, completion: nil)
    }
    
    func getAreaColor(atLocation location: CGPoint, withFrameSize size: CGSize)-> UIColor {
        
        var totalR: CGFloat = 0
        var totalG: CGFloat = 0
        var totalB: CGFloat = 0
        var rad :CGFloat = 0
        var count: CGFloat = 0
        
        let x: CGFloat = location.x
        let y: CGFloat = location.y
        let pixelPoint: CGPoint = CGPoint(x: x, y: y)
        let xx: CGFloat = imageView.frame.size.width
        let yy: CGFloat = imageView.frame.size.height
        
        if xx<yy{
            rad = xx*0.02
            print("xx = \(rad)")
        }else{
            rad = yy*0.02
            print("yy = \(rad)")
        }
        
        for i in Int(pixelPoint.x) - Int(rad) ..< Int(pixelPoint.x) + Int(rad) {
            for j in Int(pixelPoint.y) - Int(rad) ..< Int(pixelPoint.y) + Int(rad) {
                count += 1
                var rF: CGFloat = 0,
                gF: CGFloat = 0,
                bF: CGFloat = 0,
                aF: CGFloat = 0
                
                let rgba = imageView.image!.getPixelColor(atLocation: CGPoint(x:i, y:j), withFrameSize: imageView.frame.size)
                
                rgba.getRed(&rF, green: &gF, blue: &bF, alpha: &aF)
                
                totalR += rF
                totalG += gF
                totalB += bF
            }
        }
        let averageR = totalR / count
        let averageG = totalG / count
        let averageB = totalB / count
        
        print(averageR, averageG, averageB)
        
        return UIColor(red: averageR, green: averageG, blue: averageB, alpha: 1.0)
    }
 

    override func viewDidLoad() {
        super.viewDidLoad()

        splitButton.layer.borderWidth = 1
        splitButton.layer.cornerRadius = 4
        
        QRscan.layer.borderWidth = 1
        QRscan.layer.cornerRadius = 4
        
        photoTake.layer.borderWidth = 1
        photoTake.layer.cornerRadius = 4
        
        chooseBuuton.layer.borderWidth = 1
        chooseBuuton.layer.cornerRadius = 4
        
        imageView.layer.borderWidth = 0
        imageView.layer.cornerRadius = 8
        
        messageQR.layer.borderWidth = 0
        messageQR.layer.cornerRadius = 4
        
        ratio.layer.borderWidth = 0
        ratio.layer.cornerRadius = 4

        tapGesture.numberOfTapsRequired = 1
        
        imageView.image = UIImage(named: "main.jpg")
        imageView.contentMode = .scaleAspectFit
    }
    
    
    
}

