% function [h] = ht2h(ht, sz1 ,sz2)
%
% Receives a filter "ht" centered at the center of the matrix "ht", and 
% returns a filter "h" equivalent to the filter "ht",
% but of size "sz1"x"sz2" and centered at the spectral origin: pixel (1,1) 
%
% Mariana S. C. Almeida
% Instituto de Telecomunicaes, Lisbon, Portugal 
% marianascalmeida@gmail.com
 
function [h] = ht2h(ht, sz1 ,sz2)
 
h = zeros(sz1,sz2);
 
auxi = zeros(size(h)); auxi(1,1)=1; auxi = fftshift(auxi);
[c1 c2] = find(auxi==1);
 
fsize1 = ceil((size(ht,1)-1)/2);
fsize2 = floor((size(ht,1)-1)/2);
 
h( (c1-fsize1):(c1+fsize2) , (c2-fsize1):(c2+fsize2) ) = ht;
h = ifftshift(h);
