function imtext=txt2ima(text,width,height)

% Other_MEM_Text2Im - generates an image, containing the input text
% Use '#' character for new line
% Example:
% imshow(Other_MEM_Text2Im('line 0, some text#line 2',401,401,[1 0 1]));

% Written by :  Tobias Kiessling,
%               TobiasJuz@gmx.de
% Modified By:  Mohammed El-Said,
%               EngMohammedElSaid@hotmail.com
%               http://www.mohammed-elsaid.tk
% Link to the original file:
% http://www.mathworks.com/matlabcentral/fileexchange/19896-convert-text-to-an-image
      text=text+0;                    % converting string into Ascii-number array

laenge=length(text);
imtext=zeros(height,width,1);     % Preparing the resulting image

top=1;
left=0;


for i=1:laenge
    
    code=text(i);               % Ascii code of i.th letter
    left=left+1;
    
    if code==0
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;     %   .
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %   .
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %   .
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %   I       Complete
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %   I       List of all
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           % \ I /     256 ASCII
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %  \I/      Letters
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %   V
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %   .
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %   .
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;           %   .
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==1
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0;
            1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0;
            1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0;
            1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0;
            1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==2
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==3
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==4
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==5
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==6
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==7
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==8
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==9
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==10
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0;
            1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0;
            1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0;
            1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0;
            1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==11
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==12
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==13
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==14
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==15
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==16
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==17
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==18
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==19
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==20
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==21
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==22
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==23
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==24
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==25
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==26
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==27
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==28
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==29
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==30
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==31
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==32
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==33
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==34
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==35 % char = # => new line
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
        
        % start the new line
        top=top+20;
        left=0;
        continue;
    elseif code==36
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==37
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==38
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==39
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==40
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==41
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==42
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==43
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==44
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0];
    elseif code==45
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==46
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==47
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==48
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==49
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==50
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==51
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==52
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==53
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==54
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==55
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==56
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==57
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==58
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==59
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0];
    elseif code==60
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==61
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==62
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==63
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==64
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0;
            1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==65
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==66
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==67
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==68
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==69
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==70
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==71
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==72
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==73
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==74
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==75
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==76
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==77
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==78
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==79
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==80
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==81
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0];
    elseif code==82
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==83
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==84
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==85
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==86
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==87
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==88
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==89
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==90
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==91
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==92
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==93
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==94
        TxtIm=[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==95
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0];
    elseif code==96
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==97
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==98
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==99
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==100
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==101
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==102
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==103
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0];
    elseif code==104
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==105
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==106
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0];
    elseif code==107
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==108
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==109
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==110
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==111
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==112
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==113
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0];
    elseif code==114
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==115
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==116
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==117
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==118
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==119
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==120
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==121
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==122
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==123
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0];
    elseif code==124
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==125
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0];
    elseif code==126
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==127
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==128
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0];
    elseif code==129
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==130
        TxtIm=[0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==131
        TxtIm=[0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==132
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==133
        TxtIm=[0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==134
        TxtIm=[0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==135
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0];
    elseif code==136
        TxtIm=[0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==137
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==138
        TxtIm=[0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==139
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==140
        TxtIm=[0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==141
        TxtIm=[0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==142
        TxtIm=[1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==143
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==144
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==145
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==146
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==147
        TxtIm=[0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==148
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==149
        TxtIm=[0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==150
        TxtIm=[0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==151
        TxtIm=[0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==152
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==153
        TxtIm=[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==154
        TxtIm=[0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==155
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0];
    elseif code==156
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==157
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==158
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==159
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==160
        TxtIm=[0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==161
        TxtIm=[0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==162
        TxtIm=[0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==163
        TxtIm=[0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==164
        TxtIm=[0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==165
        TxtIm=[0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==166
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==167
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==168
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==169
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==170
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==171
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==172
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==173
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==174
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==175
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==248
        TxtIm=[0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0;
            1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0];
    elseif code==177
        TxtIm=[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0;
            1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0];
    elseif code==178
        TxtIm=[1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0];
    elseif code==179
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==180
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==181
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==182
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==183
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==184
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==185
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==186
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==187
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==188
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==189
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==190
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==191
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==192
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==193
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==194
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==195
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==196
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==197
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==198
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==199
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==200
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==201
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==202
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==203
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==204
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==205
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==206
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==207
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==208
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==209
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==210
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==211
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==212
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==213
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==214
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==215
        TxtIm=[0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0];
    elseif code==216
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==217
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==218
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==219
        TxtIm=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1];
    elseif code==220
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1];
    elseif code==221
        TxtIm=[1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0];
    elseif code==222
        TxtIm=[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1];
    elseif code==223
        TxtIm=[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==224
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==225
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==226
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==227
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==228
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==229
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==230
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==231
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==232
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==233
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==234
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==235
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==236
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==237
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==238
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==239
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==240
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==241
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==242
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==243
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==244
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0];
    elseif code==245
        TxtIm=[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==246
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==247
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==176
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==249
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==250
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==251
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==252
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==253
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==254
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    elseif code==255
        TxtIm=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    end
  

%%
        imtext(top:top+19,((left-1)*18+1):left*18,1)=TxtIm;
        imtext(61:height,:,:) = 1;
end